// ContentsEscY.cpp : CContentsEscY Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscY, CObject, 1)



// Serialize draw data
void CContentsEscY::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscY::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);

	int OldBkMode = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));

	for( int i = 0; i < m_Data.iCount; i++ )
	{		
		pDC->MoveTo(m_Data.iX[i],m_Data.iY[i]);
		pDC->LineTo(m_Data.iX[(i+1)%m_Data.iCount],m_Data.iY[(i+1)%m_Data.iCount]);
	}

	pDC->SetBkMode( OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
}

// Transmit the data to GP
int CContentsEscY::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_Y(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iCount,m_Data.iX,m_Data.iY)) ;
}
